# cli
# Copyright 2010-2011 Karl A. Knechtel.
#
# Exception types used by the cli module.
#
# Licensed under the Generic Non-Commercial Copyleft Software License,
# Version 1.1 (hereafter "Licence"). You may not use this file except
# in the ways outlined in the Licence, which you should have received
# along with this file.
#
# Unless required by applicable law or agreed to in writing, software 
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied. See the License for the specific language governing
# permissions and limitations under the License.


class PEBKAC(Exception):
	"""Represents problems caused by the user. Any other exception will be
	treated as a programming error (crash) by the CLI. If your code raises an
	exception that should not crash the program, wrap it in one of these."""
	pass


class Done(Exception):
	"""Raised by the auto-generated 'quit' command to end the program.
	This avoids hacking around with return values from the functions
	(even though that wouldn't require any effort on the user's part).
	Also raised after crashes are reported and acknowledged."""
	pass
